# EBM Life Cycle Code Repo

This code base can be used to replicate our synthesis, defense, and density modeling experiments from our ICLR 2022 submission "EBM Life Cycle".

## Running Files

To run a file, you will need an executable file ```train.py```, ```train_longrun.py```, ```fid.py```, or ```attack.py```, along with a config file from one of the folders ```configs```, ```configs_lr```, ```configs_attack```, or ```configs_fid```.  From outside of the ```ebm-life-cycle-main``` folder, you can run the code using:

```python3 exec.py configs_folder/config_file.py```

## Shortrun Experiments

The shortun learning experiments can be implemented using the executable ```train.py``` and either ``cifar10_nonconv_resnet.py``, ```celeb_a_nonconv_resnet.py```, or ```imagenet_nonconv_resnet.py``` in the ```configs``` folder.

## Midrun Experiments

The midrun learning experiments can be implemented using the executable ```train.py``` and either ``cifar10_medconv_resnet.py`` or ```imagenet_medconv_resnet.py``` in the ```configs``` folder.

## Longrun Experiments

The longrun learning experiments can be implemented using the executable ```train_longrun.py``` and either ``cifar10_conv_sngan.py``, ```celeb_a_conv_sngan.py``` or ```imagenet_conv_sngan.py``` in the ```configs_lr``` folder.

## FID Experiments

Unofficial FID can be implemented using ```fid.py``` with a config from the ```configs_fid``` folder. Official FID can be implemented by saving images with ```fid_save_ims.ipynb``` and implementing the original FID procedure using ```fid_orig.ipynb``` in the ```fid_orig``` folder.

## Defense Evaluation

EBM defense can be evaluated using the file ```attack.py``` with a config file from the ```configs_attack``` folder.